-- =============================================
-- New tables and quota table modifications to
-- accomodate the new Roles feature 
-- NORC dev
-- Jan 2012 
-- =============================================

/* Create Role table */

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Role]') AND type in (N'U'))
BEGIN
	CREATE TABLE [dbo].[Role](
		[Id] [int] IDENTITY(1,1) NOT NULL,
		[Name] [nvarchar](50) NOT NULL,
		[Category] [nvarchar](50) NULL,
	 CONSTRAINT [PK_Role] PRIMARY KEY CLUSTERED 
	(
		[Id] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]

END
GO

/* Create RoleAssignment table */

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RoleAssignment]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RoleAssignment](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[k_Id] [int] NOT NULL,
	[RoleId] [int] NOT NULL,
 CONSTRAINT [PK_RoleAssignment] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RoleAssignment]') AND name = N'UK_RoleAssignment')
CREATE NONCLUSTERED INDEX [UK_RoleAssignment] ON [dbo].[RoleAssignment] 
(
	[k_Id] ASC,
	[RoleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RoleAssignment_Role]') AND parent_object_id = OBJECT_ID(N'[dbo].[RoleAssignment]'))
ALTER TABLE [dbo].[RoleAssignment]  WITH CHECK ADD  CONSTRAINT [FK_RoleAssignment_Role] FOREIGN KEY([RoleId])
REFERENCES [dbo].[Role] ([Id])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RoleAssignment_Role]') AND parent_object_id = OBJECT_ID(N'[dbo].[RoleAssignment]'))
ALTER TABLE [dbo].[RoleAssignment] CHECK CONSTRAINT [FK_RoleAssignment_Role]
GO


/* Add new RoleId column to Quota table */


IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'RoleId' AND object_id = OBJECT_ID(N'Quota'))
BEGIN
	ALTER TABLE Quota ADD RoleId int NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Quota_Role]') AND parent_object_id = OBJECT_ID(N'[dbo].[Quota]'))
ALTER TABLE [dbo].[Quota]  WITH CHECK ADD  CONSTRAINT [FK_Quota_Role] FOREIGN KEY([RoleId])
REFERENCES [dbo].[Role] ([Id])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Quota_Role]') AND parent_object_id = OBJECT_ID(N'[dbo].[Quota]'))
ALTER TABLE [dbo].[Quota] CHECK CONSTRAINT [FK_Quota_Role]
GO


/* Add missing PK to existing tables */
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'VersionId' AND object_id = OBJECT_ID(N'VoxcoDBVersion'))
BEGIN
	ALTER TABLE VoxcoDBVersion ADD VersionId int NOT NULL IDENTITY (1, 1)
END
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoxcoDBVersion]') AND name = N'PK_VoxcoDBVersion')
ALTER TABLE dbo.VoxcoDBVersion ADD CONSTRAINT [PK_VoxcoDBVersion] PRIMARY KEY CLUSTERED 
(
	VersionId
) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RespondentModifLog]') AND name = N'PK_RespondentModifLog')
ALTER TABLE [dbo].[RespondentModifLog] ADD  CONSTRAINT [PK_RespondentModifLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ResponseModifLog]') AND name = N'PK_ResponseModifLog')
ALTER TABLE [dbo].[ResponseModifLog] ADD  CONSTRAINT [PK_ResponseModifLog] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO




-- =============================================
-- Author:		Pascal Roy
-- Create date: Jan 2012
-- Description:	Return the Role set of the specified agent
-- =============================================
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[VX_sp_GetAgentRoles]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[VX_sp_GetAgentRoles]
GO

CREATE PROCEDURE VX_sp_GetAgentRoles
	@agentId int
AS
BEGIN
	  /*#VoxcoSystemDatabaseName#*/
      WITH ReverseRecursiveVoxcoUserObject (ParentId, k_id, [Type], Level)
      AS
      (
            -- Anchor member definition
            SELECT tblobj.ParentId, tblobj.k_id, tblobj.[Type], 0 AS Level
            FROM tblobjects AS tblobj with (nolock)
            WHERE k_id =  @agentId  OR (  k_id in (select k_id from tblalias with (nolock) where Alias_id = @agentId ) AND 
                    (  tblobj.[type] = 1 or tblobj.[type] = 5 or tblobj.[type] = 3 ) )
            UNION ALL
            
            -- Recursive member definition
            SELECT tblobj.ParentId, tblobj.k_id, tblobj.[Type], Level + 1
            FROM tblobjects AS tblobj with (nolock)
                  INNER JOIN ReverseRecursiveVoxcoUserObject  AS RRVUO  ON RRVUO.ParentId = tblobj.k_id
            WHERE ( tblobj.[type] = 1 or tblobj.[type] = 5 or tblobj.[type] = 3 ) 
      )


      -- Statement that executes the CTE
      SELECT DISTINCT RoleId
      FROM ReverseRecursiveVoxcoUserObject RRVUO with (nolock)
            INNER JOIN RoleAssignment  ska with (nolock) on RRVUO.k_id = ska.k_id
      ORDER BY RoleId
END
GO

-- CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBuffer]  (moved to 1001)

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_New]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_New]
GO
CREATE PROCEDURE  [dbo].[sp_New]  
	@ProjectId int, 
	@GroupNbr int , 
	@BrowseNbr int,
	@LocalTimeZone int,
	@DialingMask int = 0xFF -- Bit: NA,NA,NA,NA,NA,PV,NP,PR 
AS
	--sp_New kept for legacy. See VX_sp_FillCaseBuffer
	--@LocalTimeZone dropped from VX_sp_FillCaseBuffer
	EXEC VX_sp_FillCaseBuffer @BrowseNbr=@BrowseNbr, @ProjectId=@ProjectId, @DialingMask=@DialingMask, @GroupNbr=@GroupNbr
GO
---  ***********************************************************
---  SP_NEW END
---  ***********************************************************
